/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;

public class RtpSender
implements Runnable {
    private PipedInputStream encodedData;
    private RtpSession rtpSession;
    private boolean isStopped;
    private FileOutputStream rtpSenderInput;
    private boolean mediaDebug;
    private Codec codec;
    private List<RtpPacket> pushedPackets;
    private Logger logger;
    private String peersHome;
    private CountDownLatch latch;

    public RtpSender(PipedInputStream encodedData, RtpSession rtpSession, boolean mediaDebug, Codec codec, Logger logger, String peersHome, CountDownLatch latch) {
        this.encodedData = encodedData;
        this.rtpSession = rtpSession;
        this.mediaDebug = mediaDebug;
        this.codec = codec;
        this.peersHome = peersHome;
        this.latch = latch;
        this.logger = logger;
        this.isStopped = false;
        this.pushedPackets = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void run() {
        if (this.mediaDebug) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String date = simpleDateFormat.format(new Date());
            String fileName = this.peersHome + File.separator + "media" + File.separator + date + "_rtp_sender.input";
            try {
                this.rtpSenderInput = new FileOutputStream(fileName);
            }
            catch (FileNotFoundException e) {
                this.logger.error("cannot create file", e);
                return;
            }
        }
        RtpPacket rtpPacket = new RtpPacket();
        rtpPacket.setVersion(2);
        rtpPacket.setPadding(false);
        rtpPacket.setExtension(false);
        rtpPacket.setCsrcCount(0);
        rtpPacket.setMarker(false);
        rtpPacket.setPayloadType(this.codec.getPayloadType());
        Random random = new Random();
        int sequenceNumber = random.nextInt();
        rtpPacket.setSequenceNumber(sequenceNumber);
        rtpPacket.setSsrc(random.nextInt());
        int buf_size = 160;
        byte[] buffer = new byte[buf_size];
        int timestamp = 0;
        long sleepTime = 0L;
        long offset = 0L;
        long lastSentTime = System.nanoTime();
        boolean firstTime = true;
        while (!this.isStopped) {
            byte[] trimmedBuffer;
            int numBytesRead;
            try {
                int tempBytesRead;
                for (numBytesRead = 0; !this.isStopped && numBytesRead < buf_size; numBytesRead += tempBytesRead) {
                    tempBytesRead = this.encodedData.read(buffer, numBytesRead, buf_size - numBytesRead);
                }
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
                return;
            }
            if (numBytesRead < buffer.length) {
                trimmedBuffer = new byte[numBytesRead];
                System.arraycopy(buffer, 0, trimmedBuffer, 0, numBytesRead);
            } else {
                trimmedBuffer = buffer;
            }
            if (this.mediaDebug) {
                try {
                    this.rtpSenderInput.write(trimmedBuffer);
                }
                catch (IOException e) {
                    this.logger.error("cannot write to file", e);
                    break;
                }
            }
            if (this.pushedPackets.size() > 0) {
                RtpPacket pushedPacket = this.pushedPackets.remove(0);
                rtpPacket.setMarker(pushedPacket.isMarker());
                rtpPacket.setPayloadType(pushedPacket.getPayloadType());
                rtpPacket.setIncrementTimeStamp(pushedPacket.isIncrementTimeStamp());
                byte[] data = pushedPacket.getData();
                rtpPacket.setData(data);
            } else {
                if (rtpPacket.getPayloadType() != this.codec.getPayloadType()) {
                    rtpPacket.setPayloadType(this.codec.getPayloadType());
                    rtpPacket.setMarker(false);
                }
                rtpPacket.setData(trimmedBuffer);
            }
            rtpPacket.setSequenceNumber(sequenceNumber++);
            if (rtpPacket.isIncrementTimeStamp()) {
                timestamp += buf_size;
            }
            rtpPacket.setTimestamp(timestamp);
            if (firstTime) {
                this.rtpSession.send(rtpPacket);
                lastSentTime = System.nanoTime();
                firstTime = false;
                continue;
            }
            sleepTime = 19500000L - (System.nanoTime() - lastSentTime) + offset;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(Math.round((float)sleepTime / 1000000.0f));
                }
                catch (InterruptedException e) {
                    this.logger.error("Thread interrupted", e);
                    return;
                }
                this.rtpSession.send(rtpPacket);
                lastSentTime = System.nanoTime();
                offset = 0L;
                continue;
            }
            this.rtpSession.send(rtpPacket);
            lastSentTime = System.nanoTime();
            if (sleepTime >= -20000000L) continue;
            offset = sleepTime + 20000000L;
        }
        if (this.mediaDebug) {
            try {
                this.rtpSenderInput.close();
            }
            catch (IOException e) {
                this.logger.error("cannot close file", e);
                return;
            }
        }
        this.latch.countDown();
        if (this.latch.getCount() != 0L) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.logger.error("interrupt exception", e);
            }
        }
    }

    public synchronized void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void pushPackets(List<RtpPacket> rtpPackets) {
        this.pushedPackets.addAll(rtpPackets);
    }
}

